<?php   if(!defined('DEDEINC')) exit('Request Error!');
/**
 * HeliDatelist 带普通标签解析的数据列表类
 *
 * @version        $Id: helidatalist.class.php 0.1 16:31 2013年1月26日Z tianya $
 * @package        heli.Libraries
 * @copyright      Copyright (c) 2013 - 2015, Heli
 * @license        http://www.heliweb.net
 * @link           http://www.heliweb.net
 */
 
require_once(DEDEINC.'/channelunit.class.php');

/**
 * HeliDatelist 带普通标签解析的数据列表类
 *
 * @package          Heli
 * @subpackage       DedeCMS.Libraries
 * @link             http://www.heliweb.net
 */
class HeliDatelist {
    var $dsql;
	var $Sql;
    var $dtp;
	var $dtp2;
    var $PageNo;
    var $TotalPage;
    var $TotalResult;
    var $PageSize;
    var $Fields;
    var $Templet;
    var $nowurl;

    /**
     *  php5构造函数
     *
     * @access    public
     * @param     string  $sql  SQL语句
     * @param     string  $title  数据列表的标题
	 * @param     string  $templet  模板文件
     * @return    void
     */
    function __construct($sql, $title ,$templet)
    {
        global $dsql,$pageno;
        $this->Templet = $templet;
        $this->Sql = $sql;
        $this->dsql = $dsql;
		$this->PageNo = $pageno;
		$this->nowurl = $this->GetCurUrl().'?';


		
        $this->dtp = new DedeTagParse();
        $this->dtp->SetRefObj($this);
        $this->dtp->SetNameSpace("dede","{","}");       
		$this->dtp2 = new DedeTagParse();
        $this->dtp2->SetNameSpace("field","[","]");		
       
        $this->Fields['title'] = $title;

        //设置一些全局参数的值
        foreach($GLOBALS['PubFields'] as $k=>$v) $this->Fields[$k] = $v;

        //初始化模板
        $tempfile = $GLOBALS['cfg_basedir'].$GLOBALS['cfg_templets_dir']."/".$GLOBALS['cfg_df_style'].'/'.$this->Templet;
        if(!file_exists($tempfile)||!is_file($tempfile))
        {
            echo "模板文件不存在，无法解析列表！";
            exit();
        }
        $this->dtp->LoadTemplate($tempfile);
		
		
       

    }

    //php4构造函数
    function TagList($sql, $title ,$templet)
    {
        $this->__construct($sql, $title ,$templet);
    }

    //关闭相关资源
    function Close()
    {
        @$this->dsql->Close();
    }

    /**
     *  统计列表里的记录
     *
     * @access    private
     * @return    void
     */
    function CountRecord()
    {
        //统计数据库记录	
        if(empty($this->PageNo) && !is_numeric($this->PageNo) )
        {
            $this->PageNo = 1;
        }
		
		$countQuery = preg_replace("#SELECT[ \r\n\t](.*)[ \r\n\t]FROM#is", 'SELECT COUNT(*) AS dd FROM', $this->Sql);
		$countQuery = preg_replace("#ORDER[ \r\n\t]{1,}BY(.*)#is", '', $countQuery);
		$row = $this->dsql->GetOne($countQuery);
		if(!is_array($row)) $row['dd'] = 0;
		$this->TotalResult = isset($row['dd'])? $row['dd'] : 0;         

		$ctag = $this->dtp->GetTag("helilist");	
		if(is_object($ctag) && $ctag->GetAtt("pagesize")!='')		{
			$this->PageSize = $ctag->GetAtt("pagesize");
		}
		else
		{
			$this->PageSize = 25;
		}
        $this->TotalPage = ceil($this->TotalResult/$this->PageSize);
    }
	
	 /**
     *  获取内容
     *
     * @access    public
     * @return    string
     */
    function GetResult()
    {
		$this->ParseTempletsFirst();
        return $this->dtp->GetResult();
    }


    /**
     *  显示列表
     *
     * @access    public
     * @return    void
     */
    function Display()
    {
        $this->ParseTempletsFirst();
        $this->dtp->Display();
    }

    /**
     *  解析模板，对固定的标记进行初始给值
     *
     * @access    private
     * @return    void
     */
    function ParseTempletsFirst()
    {
		if($this->Sql!='')
        {
            $this->CountRecord();
        }
        MakeOneTag($this->dtp,$this);
        if($this->Sql!='')
        {
            $this->ParseDMFields($this->PageNo,0);
        }
        $this->Close();        
    }

    /**
     *  解析模板，对内容里的变动进行赋值
     *
     * @access    public
     * @param     int  $PageNo  页码
     * @param     int  $ismake  是否编译
     * @return    string
     */
    function ParseDMFields($PageNo, $ismake=1)
    {
        foreach($this->dtp->CTags as $tagid=>$ctag){
            if($ctag->GetName()=="helilist")
            {
                $limitstart = ($this->PageNo-1) * $this->PageSize;
                if($limitstart<0)
                {
                    $limitstart = 0;
                }
                $row = $this->PageSize;
                if(trim($ctag->GetInnerText())=="")
                {
                    $InnerText = GetSysTemplets("list_fulllist.htm");
                }
                else
                {
                    $InnerText = trim($ctag->GetInnerText());
                }
                $this->dtp->Assign($tagid,
                $this->GetList(
                $limitstart,
                $row,
                $ctag->GetAtt("orderby"),
                $InnerText,
                $ismake,
				$ctag->GetAtt("orderWay")
                )
                );
            }
            else if($ctag->GetName()=="pagelist")
            {
                $list_len = trim($ctag->GetAtt("listsize"));
                $ctag->GetAtt("listitem")=="" ? $listitem="info,index,pre,pageno,next,end,option" : $listitem=$ctag->GetAtt("listitem");
                if($list_len=="")
                {
                    $list_len = 3;
                }
                if($ismake==0)
                {
                    $this->dtp->Assign($tagid,$this->GetPageListDM($list_len,$listitem));
                }
                else
                {
                    $this->dtp->Assign($tagid,$this->GetPageListST($list_len,$listitem));
                }
            }
        }
    }
	
	/**
     *  获得一个单列的列表
     *
     * @access    public
     * @param     int  $limitstart  限制开始  
     * @param     int  $row  每页多少条记录
     * @param     int  $orderby  排列顺序
	 * @param     string  $ismake  是否编译
     * @param     string  $orderWay  排序方式
	 * @return    string
     */
	 function GetList($limitstart=0,$row=10,$orderby='default',$InnerText='',$ismake=1,$orderWay='desc') {
		$getrow = ($row=='' ? 10 : $row);
        if($limitstart=='') $limitstart = 0;
		$orderby = ($orderby=='' ? 'default' : strtolower($orderby) );
        if($orderWay=='') $orderWay = 'desc';
		$InnerText = trim($InnerText);
        if($InnerText=='') $InnerText = GetSysTemplets("list_fulllist.htm");
		if($orderby != 'default' && $orderWay) {
			$ordersql = " ORDER BY $orderby $orderWay ";
		} else {
			$ordersql = '';
		}
		$query = $this->Sql." $ordersql LIMIT $limitstart,$getrow";
		
		$this->dsql->SetQuery($query);
        $this->dsql->Execute('al');
		
		$artlist = '';
		$this->dtp2->LoadSource($InnerText);
        $GLOBALS['autoindex'] = 0;
		$row2 = $this->PageSize;
       // dump($this);
		
		while($row = $this->dsql->GetArray("al"))
		{
			$GLOBALS['autoindex']++;
			$ids[$row['id']] = $row['id'];

			if(is_array($this->dtp2->CTags))
			{
				foreach($this->dtp2->CTags as $k=>$ctag)
				{
					if($ctag->GetName()=='array')
					{
						//传递整个数组，在runphp模式中有特殊作用
						$this->dtp2->Assign($k,$row);
					}
					else
					{
						if(isset($row[$ctag->GetName()]))
						{
							$this->dtp2->Assign($k,$row[$ctag->GetName()]);
						}
						else
						{
							$this->dtp2->Assign($k,'');
						}
					}
				}
			}
			$artlist .= $this->dtp2->GetResult();
		}//if hasRow	
		$this->dsql->FreeResult('al');		
		return $artlist;
	 }
	
	
	/**
	 *  传递参数
	 * @access    public
     * @param     strint  $k  键
     * @param     string  $val  值
     * @return    string
	 */
	 function Assign($k,$val) {
	 	$this->nowurl .= $k.'='.$val.'&';
	 }
	 
    /**
     *  获取动态的分页列表
     *
     * @access    public
     * @param     int  $list_len  列表宽度
     * @param     string  $listitem  列表样式
     * @return    string
     */
    function GetPageListDM($list_len,$listitem="info,index,end,pre,next,pageno")
    {
        $prepage="";
        $nextpage="";
        $prepagenum = $this->PageNo - 1;
        $nextpagenum = $this->PageNo + 1;
        if($list_len == "" || preg_match("/[^0-9]/", $list_len))
        {
            $list_len = 3;
        }
        $totalpage = $this->TotalPage;
        if($totalpage <= 1 && $this->TotalResult > 0)
        {
            return "<span class=\"pageinfo\">共1页/".$this->TotalResult."条</span>";
        }
        if($this->TotalResult == 0)
        {
            return "<span class=\"pageinfo\">共0页/".$this->TotalResult."条</span>";
        }
        $maininfo = "<span class=\"pageinfo\">共{$totalpage}页/".$this->TotalResult."条</span>\r\n";
        //$purl = $this->GetCurUrl();
        //这里对需要传递的值进行处理
        $purl .= "?".$this->nowurl;

        //获得上一页和下一页的链接
        if($this->PageNo != 1)
        {
            $prepage.="<li><a href='".$purl."pageno=$prepagenum'>上一页</a></li>\r\n";
            $indexpage="<li><a href='".$purl."pageno=1'>首页</a></li>\r\n";
        }
        else
        {
            $indexpage="<li><a>首页</a></li>\r\n";
        }
        if($this->PageNo!=$totalpage && $totalpage>1)
        {
            $nextpage.="<li><a href='".$purl."pageno=$nextpagenum'>下一页</a></li>\r\n";
            $endpage="<li><a href='".$purl."pageno=$totalpage'>末页</a></li>\r\n";
        }
        else
        {
            $endpage="<li><a>末页</a></li>\r\n";
        }

        //获得数字链接
        $listdd="";
        $total_list = $list_len * 2 + 1;
        if($this->PageNo >= $total_list)
        {
            $j = $this->PageNo - $list_len;
            $total_list = $this->PageNo + $list_len;
            if($total_list > $totalpage)
            {
                $total_list = $totalpage;
            }
        }
        else
        {
            $j=1;
            if($total_list > $totalpage)
            {
                $total_list = $totalpage;
            }
        }
        for($j; $j<=$total_list; $j++)
        {
            if($j == $this->PageNo)
            {
                $listdd.= "<li class=\"thisclass\"><a>$j</a></li>\r\n";
            }
            else
            {
                $listdd.="<li><a href='".$purl."pageno=$j'>".$j."</a></li>\r\n";
            }
        }
        $plist  =  '';
        if(preg_match('/info/i', $listitem))
        {
            $plist .= $maininfo.' ';
        }
        if(preg_match('/index/i', $listitem))
        {
            $plist .= $indexpage.' ';
        }
        if(preg_match('/pre/i', $listitem))
        {
            $plist .= $prepage.' ';
        }
        if(preg_match('/pageno/i', $listitem))
        {
            $plist .= $listdd.' ';
        }
        if(preg_match('/next/i', $listitem))
        {
            $plist .= $nextpage.' ';
        }
        if(preg_match('/end/i', $listitem))
        {
            $plist .= $endpage.' ';
        }
        return $plist;
    }

    /**
     *  获得当前的页面文件的url
     *
     * @access    private
     * @return    string
     */
    function GetCurUrl()
    {
        if(!empty($_SERVER["REQUEST_URI"]))
        {
            $nowurl = $_SERVER["REQUEST_URI"];
            $nowurls = explode("?",$nowurl);
            $nowurl = $nowurls[0];
        }
        else
        {
            $nowurl = $_SERVER["PHP_SELF"];
        }
        return $nowurl;
    }
}